#!/usr/local/bin/perl
#memchk.pl
# check the amount of free memory and swap space

$meg = (1024 * 1024);

#
## get the amount of memory
#
$data = `/sbin/memsize`;
chomp($data);
printf "     total memory %12s bytes %12s MB\n\n",&add_commas($data),&add_commas($data / $meg);

##
### get the amount of swap space
##
#@data = `/usr/sbin/swap -l`;
#chomp($data[1]);
#@parts = split(/[\s]+/,$data[1]);
#$swaptotblocks = $parts[3];
#$swapfreeplocks = $parts[4];
#printf "       total swap %12s bytes %12s MB\n\n",&add_commas($swaptotblocks * 512),&add_commas(($swaptotblocks * 512) / $meg);

#
## get the free memory
## sar reports the number of pages -- pagesize = 4k?
#
@sardata=`/usr/bin/sar -r 5 1`;
$size=@sardata;
($time,$mem,$swap)=split(/[\s]+/,$sardata[$size-1]);
$freemem = $mem * 4096;
$freememmeg = $freemem / $meg;

$freeswap = $swap * 4096;
$freeswapmeg = $freemem / $meg;

printf "%8d pages =  %12s bytes free memory\n",$mem,&add_commas($freemem);
printf "%8d pages =  %12s bytes free swap\n",$swap,&add_commas($freeswap);
printf "%8d pages =  %12s bytes free virtual memory    \n\n",($swap+$mem),&add_commas($freeswap+$freemem);

#
## get the reserved memory
## swap reports the number of 512 byte blocks available
#
@swapdata=`/usr/sbin/swap -s`;
@parts=split(/[\s]+/,$swapdata[1]);
$allocblocks = $parts[1];
$resblocks = $parts[4];
$allocmem = $allocblocks * 512;
$allocmeg = $allocmem / $meg;
$resmem = $resblocks * 512;
$resmeg = $resmem / $meg;
@parts=split(/[\s]+/,$swapdata[2]);
$availblocks = $parts[0];
$availmem = $parts[0] * 512;

printf "%8d blocks = %12s bytes allocated\n",$allocblocks,&add_commas($allocmem);
printf "%8d blocks = %12s bytes reserved\n",$resblocks,&add_commas($resmem);
printf "%8d blocks = %12s bytes alloc or reserved \n\n",($resblocks+$allocblocks),&add_commas($resmem+$allocmem);
printf "%8d blocks = %12s bytes available swap\n\n",$availblocks,&add_commas($availmem);
$tot = $resmem + $allocmem + $availmem;
printf "                  %12s bytes total swap\n\n",&add_commas($tot);

#print "$time free: $freemem reserved: $resmem\n";
$diff = ($freemem - $resmem);
if ($diff < "100000")
{
  print " Low memory  \n";
}

printf "                      %8d MB memory free\n",$freememmeg;
printf "                      %8d MB memory reserved\n",$resmeg;

sub add_commas
{
    my (@parts, $ccount, $char, $str);
    $ccount = 0;
    $wholenumber = (split(/\./,$_[0]))[0];
    
    @parts=split(//,$wholenumber);
    while ($#parts >= 0)
    {
        $ccount++;
        $char = pop(@parts);
        $str = $char.$str;
        if (($ccount == 3) && ($#parts != -1))
        {
            $str = ",".$str;
            $ccount = 0;
        }
    }
    return($str);
}

