#!/usr/local/bin/perl
#mm.pl
# check a machine
#	ethernet port
#	filesystems
#	sar -q
#	sar -r
#	sar -u
# version 
#	send all results (with details) in one file

my @parts, @text;

###
# configuration variables

$BINDIR = "/home/adm/bin";
$TARGET = "135.249.244.150"; # cplinux
$PORT   = 2345;

#
## which OS are we running
#
$OS     = `/bin/uname`;
chop($OS);

#
## what machine are we on
#
    chop($mach = `/bin/uname -n`);
    @parts = split(/\./,$mach);
    if ($#parts > 0)
    {
      $mach = $parts[0];
    }
#    print "$mach\n";
    push(@text,$mach);

#
## can we reach the server?
#

    @data=`$BINDIR/mm_network.pl $TARGET`;
    parse_output();
   
#
## get information about filesystems
#
#print "filesystems\n";
    @data=`$BINDIR/mm_disk.pl 15`;
    parse_output();

#
## get information from sar
#
#print "-> sar -u\n";
    if ($OS ne "Linux")
    {
        @data = `$BINDIR/mm_sar.pl $mach -u`;
        parse_output();
    }

#
##print "-> sar -q\n";
#
    if ($OS ne "Linux")
    {
        @data = `$BINDIR/mm_sar.pl $mach -q`;
        parse_output();
    }

#
##print "-> sar -r\n";
#
    if (($OS ne "HP-UX") && ($OS ne "Linux"))
    {
        @data = `$BINDIR/mm_sar.pl $mach -r`;
        parse_output();
    }

    send_it();

#    foreach $line (@text)
#    {
#        print "$line\n";
#    }

sub parse_output
{
#
## "-" = failed
## "+" = passed
## "!" = warn
#
    $lcount = #$data;
    $line = $data[0];
    chop($line);
    ($machine,$test,$flag,$results) = split(/\s/,$line,4);

#print "[$test] [$flag] [$results]\n";

    if ($test eq "network")
    {
        if ($flag == -1)
        {
            print "cannot contact server\n";
            exit;
        }
        else
        {
            $res{$test} = $results;
	    $flags{$test} = "+";
        }
        $text[0] = sprintf "%s %s",$text[0],$flags{$test};
        $ans = sprintf "%s %s %s",$mach,$test,$res{$test};
        push(@text,$ans);
    }
    elsif ($test eq "filesystems")
    {
        if ($flag != 0)
        {
            $res{$test} = $results;
	    $flags{$test} = "-";
        }
        else
        {
            $res{$test} = "";
	    $flags{$test} = "+";
        }
        $text[0] = sprintf "%s %s",$text[0],$flags{$test};
        $ans = sprintf "%s %s %s",$mach,$test,$res{$test};
        push(@text,$ans);
    }
    elsif ($test eq "sar-u")
    {
        if ($flag != -1)
        {
            $res{$test} = $results;
	    $flags{$test} = "+";
        }
        else
        {
            $res{$test} = "";
	    $flags{$test} = "-";
        }
        $text[0] = sprintf "%s %s",$text[0],$flags{$test};
        $ans = sprintf "%s %s %s",$mach,$test,$res{$test};
        push(@text,$ans);
    }
    elsif ($test eq "sar-q")
    {
        if ($flag != -1)
        {
            $res{$test} = $results;
	    $flags{$test} = "+";
        }
        else
        {
            $res{$test} = "";
	    $flags{$test} = "-";
        }
        $text[0] = sprintf "%s %s",$text[0],$flags{$test};
        $ans = sprintf "%s %s %s",$mach,$test,$res{$test};
        push(@text,$ans);
    }
    elsif ($test eq "sar-r")
    {
        if ($flag != -1)
        {
            $res{$test} = $results;
	    $flags{$test} = "+";
        }
        else
        {
            $res{$test} = "";
	    $flags{$test} = "-";
        }
        $text[0] = sprintf "%s %s",$text[0],$flags{$test};
        $ans = sprintf "%s %s %s",$mach,$test,$res{$test};
        push(@text,$ans);
    }
}

sub send_it
{
    require 5.002;
    #use strict;
    use Socket;
    
######################
##BEGIN network "magic"
    my ($remote, $port, $iaddr, $paddr, $proto, $line);
    
    $remote = $TARGET;
    $port = $PORT;
    if ($port =~/\D/) { $port = setservbyname($port, 'tcp') }
    die "bad port" unless $port;
    $iaddr = inet_aton($remote)		        or die "bad host: $remote";
    $paddr = sockaddr_in($port, $iaddr);
    $proto = getprotobyname('tcp');
    socket(SOCK, PF_INET, SOCK_STREAM, $proto)  or die "socket: $!";
    connect (SOCK, $paddr)			or die "connect: $!";
##END network "magic"
######################
# we now have a filehandle named SOCK that we can write to
    
    foreach $line (@text)
    {
        print SOCK "$line\n";
#        print "$line\n";
    }
    close (SOCK)				or die "close: $!";
}
