#!/usr/bin/perl
#df_linux

#
## what is the threshold value? if not given use 15%
#
  if ($#ARGV == -1)
  {
    $level = 15;
  }
  else
  {
    $level = $ARGV[0];
  }

$lc = 0;
 
#
## get information about disk space
#
open(IN,"/bin/df |");
@space=<IN>;
close IN;

foreach $line (@space)
{
    if ($lc == 0)
    {
	$lc++;
    }
    else
    {
	chop($line);
	@parts = split(/[\s]+/,$line);
#print "[$parts[5]] [$parts[4]]\n";
	$filesys = $parts[5];
	($used) = split(/%/,$parts[4]);
	$pct = (100 - $used);
	$sizes{$mounts{$parts[0]}} = $pct;
	$values{$filesys} = $pct;
#       printf "%25s %6.2f\n",$filesys,$pct;
	$lc++;
    }
}
 
#
## check for list of filesystems to exclude
#
  $file = "mm_disk.conf";
  if (-f $file)
  {
      open(IN,$file);
      while ($line = <IN>)
      {
        chop($line);
        ($fs,$newlev) = split(/[\s]+/,$line);
        if ($values{$fs} > $newlev)
        {
            $values{$fs} = "";
        }
      }
      close (IN);
  }
  $values{"/cdrom"} = "";
  $values{"/dev/fd"} = "";
  $values{"/proc"} = "";
 
#
## compare what is left to the threshold
#
  foreach $index (sort keys %values)
  {
      if (($values{$index} ne "") && ($values{$index} < $level))
      {
          printf " %-25s %6.2f\n",$index,$values{$index};
      }
#      else
#      {
#          printf "REJECT%-25s %6.2f\n",$index,$values{$index};
#      }
  }

