#!/usr/local/bin/perl
#df_sysV
#	find disk space on system V machine

#
## what is the threshold value? if not given use 15%
#
  if ($#ARGV == -1)
  {
    $level = 15;
  }
  else
  {
    $level = $ARGV[0];
  }

#
## get information about disk space
#
open (IN,"/bin/df -t |");
@data = <IN>;
close IN;

for ($i = 0; $i <= $#data; $i = $i + 2)
{
	($front,$back) = split(/\:[\s]+/,$data[$i]);
	($filesys) = split(/[\s]+/,$front);
	($used) = split(/[\s]+/,$back);

	($front,$back) = split(/:[\s]+/,$data[$i + 1]);
	($total) = split(/[\s]+/,$back);
	if ($total != 0)
	{
		$pct = ($used / $total) * 100;
	}
	
	$values{$filesys} = $pct;
#	printf "%25s %6.2f\n",$filesys,$pct;
}

#
## check for list of filesystems to exclude
#
  $file = "mm_disk.conf";
  if (-f $file)
  {
      open(IN,$file);
      while ($line = <IN>)
      {
        chop($line);
        ($fs,$newlev) = split(/[\s]+/,$line);
        if ($values{$fs} > $newlev)
        {
            $values{$fs} = "";
        }
      }
      close (IN);
  }
  $values{"/cdrom"} = "";
  $values{"/dev/fd"} = "";
  $values{"/proc"} = "";

#
## compare what is left to the threshold
#
  foreach $index (sort keys %values)
  {
      if (($values{$index} ne "") && ($values{$index} < $level))
      {
          printf " %-25s %6.2f\n",$index,$values{$index};
      }
#      else
#      {
#          printf "REJECT%-25s %6.2f\n",$index,$values{$index};
#      }
  }

