#!/usr/bin/perl
#mm_bildtable.pl
# 
## report "non-green" in a different section
##  but also leave them where they belong
#

$DIR="/images/";
$DATADIR="/tmp/mmdata";
$TIME_BETWEEN_SAMPLES = 900; # in seconds

my (%values);

#
# build the machine list
#
$mach{"mickey"} = "mickey";
$mach{"minnie"} = "minnie";
$mach{"goofy"} = "goofy";
$mach{"donald"} = "donald";

opendir(DIR,"$DATADIR");
while($line=readdir(DIR))
{
	($mname) = split(/\./,$line);
	if ($mname ne "")
	{
		$mach{$mname} = $mname;
	}
#        print "[$line] [$mname]\n";
}
closedir DIR;


#
## the list of tests (in order)
#
@tlist = ("network", "filesystems", "sar-q", "sar-r", "sar-u");

#
## the list of colors to use
#
$green  = "#00ff00";
$red    = "#ff0000";
$yellow = "#ffff00";
$gray   = "#d0d0d0";
$blue   = "#00ffff";
$orange = "#ff8800";
$white = "#ffffff";

$count = 0;
$rcount = 0;
my $input, $nline, $rcount;

#
## create the header for the html document
#
bild_header();

#
## create the beginning of the tables
#
start_tables();


foreach $i (sort keys %mach)
{
    $file=$DATADIR."/".$i.".mon";
    if (-f $file)
    {
#
## determine age of file 
##  compare it's modification time 
##  to the access time of the current script
#
        $ref_time=(stat($0))[8];
        $mtime=(stat($file))[9];
        $delta = $ref_time - $mtime;

        if ($delta < $TIME_BETWEEN_SAMPLES)
        {
            current_data();
        }
        else
        {
            # not a current file
	    old_data();
        }
    }
    else
    {
        # no data file
        no_data();
    }
}

#
## finish the tables
#
  push(@lines,"</TABLE>\n");
  push(@lines,"<P>\n");
  push(@flaggers,"</TABLE>\n");
  push(@flaggers,"<P>\n");

#
## add a query line
#

add_query();

#
## finish the page
#
  push(@lines,"</BODY>\n");
  push(@lines,"</HTML>\n");

print_it();

######################################################################
sub green_box
{
    $ma = @_[0];
    $tst = @_[1];
    $val = @_[2];
    if ($val eq "")
    {
#        $nline = $nline.'<TD BGCOLOR='.$green.'>';
        $nline = $nline.'<TD BGCOLOR='.$white.'>';
        $nline = $nline.'<A HREF="mm_details.pl?'.$ma.'?'.$tst.'" TARGET="right">';
        $nline = $nline.'<IMG SRC="/green_lcd.gif" BORDER=0 WIDTH="45" HEIGHT="22">';
        $nline = $nline.'</TD>';
    }
    else
    {
        $nline = $nline.'<TD BGCOLOR='.$green.'>';
        $nline = $nline."$val";
        $nline = $nline.'</TD>';
    }
}

######################################################################
sub red_box
{
    $ma = @_[0];
    $tst = @_[1];
    $val = @_[2];
    if ($val eq "")
    {
#        $nline = $nline.'<TD BGCOLOR='.$red.'>';
        $nline = $nline.'<TD BGCOLOR='.$white.'>';
        $nline = $nline.'<A HREF="mm_details.pl?'.$ma.'?'.$tst.'" TARGET="right">';
        $nline = $nline.'<IMG SRC="/red_lcd.gif" BORDER=0 WIDTH="45" HEIGHT="22">';
        $nline = $nline.'</TD>';
    }
    else
    {
        $nline = $nline.'<TD BGCOLOR='.$red.'>';
        $nline = $nline."$val";
        $nline = $nline.'</TD>';
    }
    $rcount++;
}


######################################################################
sub yellow_box
{
    $ma = @_[0];
    $tst = @_[1];
    $val = @_[2];
    if ($val eq "")
    {
#        $nline = $nline.'<TD BGCOLOR='.$yellow.'>';
        $nline = $nline.'<TD BGCOLOR='.$white.'>';
        $nline = $nline.'<A HREF="mm_details.pl?'.$ma.'?'.$tst.'" TARGET="right">';
        $nline = $nline.'<IMG SRC="/yellow_lcd.gif" BORDER=0 WIDTH="45" HEIGHT="22">';
        $nline = $nline.'</TD>';
    }
    else
    {
        $nline = $nline.'<TD BGCOLOR='.$yellow.'>';
        $nline = $nline.'<A HREF="mm_details.pl?'.$ma.'?'.$tst.'" TARGET="right">';
        $nline = $nline."$val</A>";
        $nline = $nline.'</TD>';
    }
    $rcount++;
}


######################################################################
sub get_data
{
    open (IN,"$file");
    @input = <IN>;
    close (IN);
}

######################################################################
sub current_data
{
    $rcount = 0;
    $lc = 0;
    %tres = ();

    get_data();

    foreach $line (@input)
    {
        chop($line);
        @parts= split(/[\s]+/,$line);
        if ($lc == 0)
        {
            @flags = @parts;
            $machine = $parts[0];
        }
        else
        {
            $tres{$parts[1]} = $flags[$lc];
            $tdetails{$parts[1]} = $line;
        }
        $lc++;
    }

    $nline = '<TR ALIGN="CENTER">';

    # the first element is the machine name
    $nline = $nline.'<TD BGCOLOR='.$white.'>';
    $nline = $nline.'<A HREF="mm_mach_details.pl?'.$machine.'" TARGET="right">'.$machine.'</A>';
    $nline = $nline.'</TD>';

    foreach $test (@tlist)
    {
        @chars = split(//,$tres{$test});
        $value = substr($tres{$test},1);
        $result = $chars[0];

        if ($result eq "+")
        {
            green_box($machine,$test,$value);
        }
        elsif ($result eq "-")
        {
            red_box($machine,$test,$value);
        }
        elsif ($result eq "!")
        {
            yellow_box($machine,$test,$value);
        }
        else
        {
            $nline = $nline."<TD></TD>";
        }
    }

    $nline = $nline."</TR>\n";
    push(@lines,$nline);
    if ($rcount != 0)
    {
        push(@flaggers,$nline);
    }
}

######################################################################
sub old_data
{
      # not a current file
      $nline = '<TR ALIGN="CENTER">';
      $nline = $nline.'<TD BGCOLOR='.$blue.'>'.$i.'</TD>';
      $nline = $nline.'<TD BGCOLOR='.$orange.'>'.$i.'</TD>';
      $nline = $nline."</TR>\n";
      push(@lines,$nline);
      push(@flaggers,$nline);
}

######################################################################
sub no_data
{
    # no data file
      $nline = '<TR ALIGN="CENTER">';
      $nline = $nline.'<TD BGCOLOR='.$red.'>'.$i.'</TD>';
      $nline = $nline."</TR>\n";
      push(@lines,$nline);
      push(@flaggers,$nline);
}

######################################################################
sub bild_header
{
#
# header information - must be returned by a CGI script
#
    push(@header,"Content-type: text/html\n");
    push(@header,"\n");

#
# the beginning of the html document
#
    push(@header,"<HTML>\n");
    push(@header,"<HEAD>\n");
    push(@header,"<title>Machines - status</title>\n");
    $line="<META HTTP-EQUIV=".'"'."REFRESH".'"'." CONTENT=".'"'."60".'"'.">\n";
    push(@header,$line);
    push(@header,"</HEAD>\n");
    $line='<BODY BGCOLOR='.$white.">\n";

    push(@header,$line);
}

######################################################################
sub start_tables
{
#
# the beginning of the table of all machines
#
    push(@lines,"<TABLE BORDER=2 border>\n");
    push(@lines,"<CAPTION> Machine status </CAPTION>\n");
    $nline="<TR><TH>Machine</TH>";
    foreach $item (@tlist)
    {
        $nline = $nline."<TH>".$item."</TH>";
    }
    push(@lines,"$nline</TR>\n");

#
# the beginning of the table of "non-green" machines
#
    push(@flaggers,"<TABLE BORDER=2 border>\n");
    push(@flaggers,"<CAPTION> Machines with Problems </CAPTION>\n");
    push(@flaggers,"$nline</TR>\n");
}

######################################################################
sub print_it
{
#
# print the header
#
    foreach $line (@header)
    {
        print "$line";
    }

#
# print the "non-green" machines
#
    foreach $line (@flaggers)
    {
        print "$line";
    }

#
# print the whole list
#
    foreach $line (@lines)
    {
        print "$line";
    }
}


######################################################################
sub add_query
{
  push(@lines,'<P>'."\n");
  push(@lines,'<FORM METHOD="GET" ACTION="/cgi-bin/mm_search.pl">');
  push(@lines,'Type in a word or words to search for in the machine list:'."\n");
  push(@lines,'<INPUT TYPE="TEXT" NAME="custom" SIZE="50" MAXLENGTH="50"> '."\n");
  push(@lines,'<BR><INPUT TYPE="RESET"> '."\n");
  push(@lines,'<INPUT TYPE="SUBMIT" VALUE="Send it">'."\n");
  push(@lines,'</FORM>'."\n");
  push(@lines,'<P>'."\n");
}


######################################################################
sub get_val
{
    $tst = $_[0];
    if ($tst eq "sar-u")
    {
        $stuff = $values{"%idle"};
    }
    return($stuff);
}
