#!/usr/local/bin/perl
#mm_disk.pl

# check disk space on the machine
if ($#ARGV == -1)
{
        print "USAGE: $0 <threshold value> \n";
	print " defaulting to 15 percent\n";
        $value = 15;
}
else
{
        $value = $ARGV[0];
}

$lc = 0;

($os,$tmpmach)=split(/ /,`/bin/uname -a`);
($mach) = split(/\./,$tmpmach);

#print "$os\n";

if ($os eq "Linux")
{
    df_linux($value);
#    foreach $line (@output)
#    {
#       chop($line);
#       @parts = split(/[\s]+/,$line);
#       $lines[$lc] = $parts[1]." ".$parts[2];
#       $lc++;
##       print "$line";
#    }
#    close IN;
#    
#    print "$mach filesystems $lc";
#    
#    for ($count = 0; $count < $lc; $count++)
#    {
#      print " $lines[$count]";
#    }
}
else
{
    if ($os eq "HP-UX")
    {
        $cmd = "/bin/df -P";
    }
    else
    {
        $cmd = "/bin/df -t";
    }

    df_sysV($value,$cmd);
}
    foreach $line (@output)
    {
       chop($line);
       @parts = split(/[\s]+/,$line);
       $lines[$lc] = $parts[1]." ".$parts[2];
       $lc++;
#       print "$line";
    }
    
    print "$mach filesystems $lc";
    if ($lc > 0)
    {
        print " Filesystem %free";
    }
    
    for ($count = 0; $count < $lc; $count++)
    {
      print " $lines[$count]";
    }



############################################################
sub df_sysV
{

#	find disk space on system V machine

#
## what is the threshold value? if not given use 15%
#
    $level = $_[0];
    $command = $_[1];

#
## get information about disk space
#
    open (IN,"$command |");
    @data = <IN>;
    close IN;

    for ($i = 0; $i <= $#data; $i = $i + 2)
    {
	($front,$back) = split(/\:[\s]+/,$data[$i]);
	($filesys) = split(/[\s]+/,$front);
	($used) = split(/[\s]+/,$back);

	($front,$back) = split(/:[\s]+/,$data[$i + 1]);
	($total) = split(/[\s]+/,$back);
	if ($total != 0)
	{
   	    $pct = ($used / $total) * 100;
	}
	
	$values{$filesys} = $pct;
#	printf "%25s %6.2f\n",$filesys,$pct;
    }

#
## check for list of filesystems to exclude
#
    exclude_fs($level);
}


############################################################
sub df_linux
{
#
## what is the threshold value? if not given use 15%
#
    $level = $_[0];
 
#
## get information about disk space
#
    open(IN,"/bin/df |");
    @space=<IN>;
    close IN;

    foreach $line (@space)
    {
        chop($line);
        @parts = split(/[\s]+/,$line);
#        print "[$parts[5]] [$parts[4]]\n";
        if ($parts[0] ne "Filesystem")
        {
            $filesys = $parts[5];
            ($used) = split(/%/,$parts[4]);
            $pct = (100 - $used);
            $sizes{$mounts{$parts[0]}} = $pct;
            $values{$filesys} = $pct;
#            printf "%25s %6.2f\n",$filesys,$pct;
        }
    }

#
## check for list of filesystems to exclude
#
    exclude_fs($level);
}


############################################################
sub exclude_fs
{
#
## check for list of filesystems to exclude
#

    $level = $_[0];
    $file = "mm_disk.conf";
    if (-f $file)
    {
        open(IN,$file);
        while ($line = <IN>)
        {
             chop($line);
             ($fs,$newlev) = split(/[\s]+/,$line);
             if ($values{$fs} > $newlev)
             {
                 $values{$fs} = "";
             }
        }
        close (IN);
    }
    $values{"/cdrom"} = "";
    $values{"/dev/fd"} = "";
    $values{"/proc"} = "";

#
## compare what is left to the threshold
#
    foreach $index (sort keys %values)
    {
        if (($values{$index} ne "") && ($values{$index} < $level))
        {
            $line = sprintf " %-25s %6.2f\n",$index,$values{$index};
            push(@output,$line);
        }
#        else
#        {
#            printf "REJECT%-25s %6.2f\n",$index,$values{$index};
#        }
    }
}
