#!/usr/local/bin/perl
#mm_network.pl.3
# ping a machine once
#  if it is up, ping limbsbk1 and limbsbk2 from it
# version 2
#	report <machine> <result>
# version 3
#	do not report first result (pinging the machine)
#
if ($#ARGV == -1)
{
        print "USAGE: $0 <machine name> \n";
        exit();
}
else
{
        $mach = $ARGV[0];
}

$interface = $mach;
chop($uname = `/bin/uname`);

if (-f "/usr/etc/ping")
# ncr
{
	$ping = "/usr/etc/ping $interface 64 1";
	$targetline = 1;
}
elsif (-f "/bin/ping")
# linux
{
	$ping = "/bin/ping -c 1 $interface";
	$targetline = 2;
}
elsif ($uname eq 'SunOS')
# sun
{
	$ping = "/usr/sbin/ping -s $interface 64 1";
	$targetline = 1;
}
elsif ($uname eq 'HP-UX')
# hp
{
	$ping = "/usr/sbin/ping $interface -n 1";
	$targetline = 2;
}

$lc = 0;
$rval = 0;

#
## run the command
#
open(IN,"$ping |");
@PING=<IN>;
close(IN);

foreach $line (@PING)
{
  chomp($line);
#  print "$line\n";

  $lc++;
  if ($lc == $targetline)
  {
    if ($line eq "")
    {
      $rval = -1;
      print "$interface network $rval\n";
    }
    else
    {
#      print "[$line]\n";
      @words=split(/[ ]+/,$line);
      if ($words[1] eq "unknown")
      {
        $rval = -1;
        print "$interface network $rval\n";
      }
      else
      {
        @parts=split(/time=/,$line);
        ($count,$rest)=split(/[ ]+/,$parts[1]);
#print "[$line] [$count] [$rest]\n";
        if ($rest eq "100th")
	{
	  $res = $count."/100";
	}
	elsif ($rest eq "ms")
	{
	  $newcount = sprintf "%d",$count / 10;
	  $res = $newcount."/100";
	}
        print "$interface network $rval $res\n";
#        print "$interface network $rval $count/$rest\n";
#        print "$interface $count/$rest\n";
      }
    }
  }
}
