#!/usr/bin/perl
#mm_search.pl
# search the "machines" file for data

print "Content-type: text/html\n";
print "\n";

if ($#ARGV != 1 && $ENV{REQUEST_METHOD} eq 'GET' && $ENV{QUERY_STRING} ne '')
{
  # split the query into keywords
  foreach $input (split("&",$ENV{QUERY_STRING}))
  {
    if ($input =~ /(.*)=(.*)/)
    {
      ($key,$value) = ($1, $2);
      $value =~ s/\+/ /g ; # replace "+" with " "
      # convert hex characters
      $value =~ s/%(..)/pack('c',hex($1))/eg;
      $inputs{$key} = $value; # add keyword/value pair to a list
    }
  }

}
$string = $inputs{"custom"};

#
## no inputs
#
if ($string eq "")
{
  print "<HTML>\n";
  print "<HEAD>\n";
  print "<title>Application Query Results</title>\n";
  print "</HEAD>\n";
  print "<BODY BGCOLOR=#FFFFFF>\n";
  print "<BR><BR><CENTER>You did not enter anything to search for!\n";
  print "</BODY>\n";
  exit;
}

$file = "machine_list.txt";
open (IN,$file);
@data=<IN>;
close IN;

@res=grep(/$string/i,@data);

#
## nothing was found
#
if ($#res == -1)
{
  print "<HTML>\n";
  print "<HEAD>\n";
  print "<title>Application Query Results</title>\n";
  print "</HEAD>\n";
  print "<BODY BGCOLOR=#FFFFFF>\n";
  print "<BR><BR><CENTER>Nothing was found!\n";
  print "</BODY>\n";
  exit;
}

  print "<HTML>\n";
  print "<HEAD>\n";
  print "<title>Application Query Results</title>\n";
  print "</HEAD>\n";
  print "<BODY BGCOLOR=#FFFFFF>\n";
  print "<TABLE BORDER=2 border>\n";

  print "<TR><TH>Machine</TH>\n";
  print "<TH>Sys Admin</TH>\n";
  print "<TH>DBA</TH>\n";
  print "<TH>Applications</TH>\n";
  print "<TH>Other</TH></TR>\n";

  foreach $line (@res)
  {
        ($name,$admin,$dba,$apps,$other)=split(/\t/,$line);
	printf "%s\n","<TR><TD><A HREF=".'"'.'mm_more_mach_details.pl?'.$name.'"'.' TARGET="right">'.$name.'</A></TD>';
	print "<TD>$admin</TD>\n";
	print "<TD>$dba</TD>\n";
	print "<TD>$apps</TD>\n";
	print "<TD>$other</TD></TR>\n";
  }

  print "</TABLE>\n";
  print "<P>\n";
  print "</BODY>\n";
  print "</HTML>\n";
